class UniversalSoldiersGame extends DeathMatchPlus config(UniversalSoldiers);

// Sounds
#exec OBJ LOAD FILE=..\Sounds\Announcer.uax

//Monster mod variables:
var config int 	NumMonsters,
		MaxMonsters;//variable to control maximum enemies a Boss monster can spawn.
var config int 	SecondsToKillBoss;
var bool 	bBossSpawned;

var int NumPoints,HSdice;

//Relics config:
var config bool bRelics;

//Ammo pickup variables:
var config int	NumAmmoPickups,
		NumAmmoCount,
		MaxAmmoCount;

var() globalconfig int  MinPlayers;		// bots fill in to guarantee this level in net game 
var() globalconfig float AirControl; 
var() config int	FragLimit; 
var() config int	TimeLimit; // time limit in minutes
var() globalconfig bool bChangeLevels;
var() globalconfig bool bHardCoreMode;
var   bool			    bChallengeMode;
var() globalconfig bool bMegaSpeed;
var() globalconfig bool	bAltScoring;
var() config bool	bMultiWeaponStay;
var() config bool	bForceRespawn;
var		bool	bAlwaysForceRespawn;
var		bool	bDontRestart;
var		bool	bAlreadyChanged;
var		bool	bFirstBlood;

var() globalconfig bool bTournament;
var  bool bRequireReady;
var() bool bNoviceMode;
var() globalconfig int NetWait; // time to wait for players in netgames w/ bNetReady (typically team games)
var() globalconfig int RestartWait;
var config bool bUseTranslocator;
var bool bJumpMatch;
var bool bThreePlus;
var bool bFulfilledSpecial;
var bool	bNetReady;
var bool bRatedTranslocator;
var bool bStartMatch;

var	int RemainingTime, ElapsedTime;
var int CountDown, StartCount;
var localized string StartUpMessage;
var localized string TourneyMessage;
var localized string WaitingMessage1;
var localized string WaitingMessage2;
var localized string ReadyMessage;
var localized string NotReadyMessage;
var localized string CountDownMessage;
var localized string StartMessage;
var localized string GameEndedMessage;
var localized string SingleWaitingMessage;
var localized string gamegoal;

var float LastTauntTime;
var NavigationPoint LastStartSpot;
var() config int	MaxCommanders;
var int   NumCommanders;

var bool bTutorialGame;

// Bot related info
var   int				NumBots;
var	  int				RemainingBots;
var	  int				LastTaunt[4];
var() globalconfig int	InitialBots;
var	ChallengeBotInfo	BotConfig;
var localized string	NoNameChange, OvertimeMessage;
var class<ChallengeBotInfo>		BotConfigType;

// Player rating variables for single player rated games
var float PlayerRating, AvgOpponentRating;
var int NumOpp, WinCount, LoseCount;
var PlayerPawn RatedPlayer;
var int IDnum;
var RatedMatchInfo RatedMatchConfig;
var float EndTime;
var int LadderTypeIndex;

var LadderInventory RatedGameLadderObj;

var config int	GameDifficulty;

function PostBeginPlay()
{
local string NextPlayerClass;
local int i;
local NavigationPoint NP;

	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if (NP.IsA('PathNode'))
			{
			NumPoints++;
			}
		}

	if ( bAlternateMode )
	{
		bVeryLowGore = true;
		bLowGore = true;
	}
	BotConfig = spawn(BotConfigType);
	if ( Level.NetMode == NM_Standalone )
		RemainingBots = InitialBots;
	else
		RemainingBots = 0;

	Super.PostBeginPlay();

	US_GRI(GameReplicationInfo).RemainingTime = RemainingTime;
	//set game difficulty:
	if ( GameDifficulty <= 1 )
		{
		US_GRI(GameReplicationInfo).Damage = 1.0;
		US_GRI(GameReplicationInfo).GameDifficulty = 1.25;
		GameDifficulty = 1;
		}
	else if ( GameDifficulty == 2 )
		{
		US_GRI(GameReplicationInfo).Damage = 0.95;
		US_GRI(GameReplicationInfo).GameDifficulty = 1.50;
		}
	else if ( GameDifficulty == 3 )
		{
		US_GRI(GameReplicationInfo).Damage = 0.9;
		US_GRI(GameReplicationInfo).GameDifficulty = 1.75;
		}
	else if ( GameDifficulty == 4 )
		{
		US_GRI(GameReplicationInfo).Damage = 0.85;
		US_GRI(GameReplicationInfo).GameDifficulty = 2.0;
		}
	else if ( GameDifficulty == 5 )
		{
		US_GRI(GameReplicationInfo).Damage = 0.75;
		US_GRI(GameReplicationInfo).GameDifficulty = 2.25;
		}
	else if ( GameDifficulty == 6 )
		{
		US_GRI(GameReplicationInfo).Damage = 0.7;
		US_GRI(GameReplicationInfo).GameDifficulty = 2.5;
		}
	else if ( GameDifficulty == 7 )
		{
		US_GRI(GameReplicationInfo).Damage = 0.65;
		US_GRI(GameReplicationInfo).GameDifficulty = 2.75;
		}
	else if ( GameDifficulty == 8 )
		{
		US_GRI(GameReplicationInfo).Damage = 0.6;
		US_GRI(GameReplicationInfo).GameDifficulty = 3.0;
		}
	else if ( GameDifficulty == 9 )
		{
		US_GRI(GameReplicationInfo).Damage = 0.55;
		US_GRI(GameReplicationInfo).GameDifficulty = 3.25;
		}
	else
		{
		US_GRI(GameReplicationInfo).Damage = 0.5;
		US_GRI(GameReplicationInfo).GameDifficulty = 3.50;
		GameDifficulty = 10;
		}

	if ( bRelics )
		Spawn(class'US_RelicMutator');
}


function PreCacheReferences()
{
	//never called - here to force precaching of meshes
	spawn(class'US_Monster_Behemoth');
	spawn(class'US_Monster_Brute');
	spawn(class'US_Monster_CaveManta');
	spawn(class'US_Monster_Fly');
	spawn(class'US_Monster_Gasbag');
	spawn(class'US_Monster_IceSkaarj');
	spawn(class'US_Monster_Krall');
	spawn(class'US_Monster_KrallElite');
	spawn(class'US_Monster_LeglessKrall');
	spawn(class'US_Monster_LesserBrute');
	spawn(class'US_Monster_Manta');
	spawn(class'US_Monster_Mercenary');
	spawn(class'US_Monster_MercenaryElite');
	spawn(class'US_Monster_Pupae');
	spawn(class'US_Monster_PupellaGuard');
	spawn(class'US_Monster_Queen');
	spawn(class'US_Monster_Skaarj');
	spawn(class'US_Monster_SkaarjAssassin');
	spawn(class'US_Monster_SkaarjBerserker');
	spawn(class'US_Monster_SkaarjGunner');
	spawn(class'US_Monster_SkaarjInfantry');
	spawn(class'US_Monster_SkaarjLord');
	spawn(class'US_Monster_SkaarjOfficer');
	spawn(class'US_Monster_SkaarjScout');
	spawn(class'US_Monster_SkaarjSniper');
	spawn(class'US_Monster_SkaarjTrooper');
	spawn(class'US_Monster_SkaarjWarrior');
	spawn(class'US_Monster_Slith');
	spawn(class'US_Monster_Slith2');
	spawn(class'US_Monster_Slith3');
	spawn(class'US_Monster_Slith4');
	spawn(class'US_Monster_StoneTitan');
	spawn(class'US_Monster_Titan');
	spawn(class'US_Monster_Titan2');
	spawn(class'US_Monster_WarLord');
	spawn(class'US_Monster_WarLord2');
	spawn(class'US_Monster_WarLord3');
	spawn(class'USW_ASMD');
	spawn(class'USW_AssaultRifle');
	spawn(class'USW_AutoMag');
	spawn(class'USW_Barret50');
	spawn(class'USW_BioRifle');
	spawn(class'USW_ChainSaw');
	spawn(class'USW_DispersionPistol');
	spawn(class'USW_DoubleEnforcer');
	spawn(class'USW_DoubleLawgiver');
	spawn(class'USW_Eightball');
	spawn(class'USW_Enforcer');
	spawn(class'USW_FlakCannon');
	spawn(class'USW_GrappleHook');
	spawn(class'USW_Lawgiver');
	spawn(class'USW_MiniGun');
	spawn(class'USW_OldEightball');
	spawn(class'USW_Painless');
	spawn(class'USW_PulseGun');
	spawn(class'USW_RazorJack');
	spawn(class'USW_ShockRifle');
	spawn(class'USW_SniperRifle');
	spawn(class'USW_Stinger');
	spawn(class'USW_Translocator');
	spawn(class'USW_TwinLauncher');
	spawn(class'USW_Uzi');
	spawn(class'US_Boss_Pupella');
}


function CheckReady()
{
	if ( (FragLimit == 0) && (TimeLimit == 0) )
	{
		TimeLimit = 20;
		RemainingTime = 60 * TimeLimit;
	}
}

//
// Set gameplay speed.
//
function SetGameSpeed( Float T )
{
	GameSpeed = FMax(T, 0.1);
	if ( bHardCoreMode )
	{
		if ( bChallengeMode )
			Level.TimeDilation = 1.25 * GameSpeed;
		else
			Level.TimeDilation = 1.1 * GameSpeed;
	}
	else
		Level.TimeDilation = GameSpeed;
	SaveConfig();
	SetTimer(Level.TimeDilation, true);
}

function PlayTeleportEffect( actor Incoming, bool bOut, bool bSound)
{
 	local UTTeleportEffect PTE;

	if ( bRequireReady && (Countdown > 0) )
		return;

	if ( Incoming.bIsPawn && (Incoming.Mesh != None) )
	{
		if ( bSound )
		{
 			PTE = Spawn(class'UTTeleportEffect',Incoming,, Incoming.Location, Incoming.Rotation);
 			PTE.Initialize(Pawn(Incoming), bOut);
			PTE.PlaySound(sound'Resp2A',, 10.0);
		}
	}
}


// Parse options for this game...
event InitGame( string Options, out string Error )
{
	local string InOpt;

	Super.InitGame(Options, Error);

	RemainingTime = 60 * TimeLimit;
	SetGameSpeed(GameSpeed);
	FragLimit = GetIntOption( Options, "FragLimit", FragLimit );
	TimeLimit = GetIntOption( Options, "TimeLimit", TimeLimit );
	MaxCommanders = GetIntOption( Options, "MaxCommanders", MaxCommanders );

	InOpt = ParseOption( Options, "CoopWeaponMode");
	if ( InOpt != "" )
	{
		log("CoopWeaponMode: "$bool(InOpt));
		bCoopWeaponMode = bool(InOpt);
	}

	IDnum = -1;
	IDnum = GetIntOption( Options, "Tournament", IDnum );
	if ( IDnum > 0 )
	{
		bRatedGame = true;
		TimeLimit = 0;
		RemainingTime = 0;
	}
	if ( bTournament ) 
	{
		bRequireReady = true;
		CheckReady();
	}
	if ( Level.NetMode == NM_StandAlone )
	{
		bRequireReady = true;
		CountDown = 1;
	}
	if ( !bRequireReady && (Level.NetMode != NM_Standalone) )
	{
		bRequireReady = true;
		bNetReady = true;
	}

}



// Set game settings based on ladder information.
// Called when RatedPlayer logs in.
function InitRatedGame(LadderInventory LadderObj, PlayerPawn LadderPlayer)
{
	local class<RatedMatchInfo> RMI;
	local Weapon W;

	FragLimit = LadderObj.CurrentLadder.Default.FragLimits[IDnum];
	RatedGameLadderObj = LadderObj;
	if (LadderObj.CurrentLadder.Default.TimeLimits[IDnum] > 0)
		TimeLimit = LadderObj.CurrentLadder.Default.TimeLimits[IDnum];
	bJumpMatch = false;
	bHardCoreMode = true;
	bRequireReady = true;
	bMegaSpeed = false;
	CountDown = 1;
	bRatedGame = true;
	bCoopWeaponMode = false;
	bUseTranslocator = bRatedTranslocator;
	ForEach AllActors(class'Weapon', W)
		W.bWeaponStay = false;

	RatedPlayer = LadderPlayer; 

	// Set up RatedBotConfig for this game
	BotConfig.bAdjustSkill = false;
	RMI = LadderObj.CurrentLadder.Static.GetMatchConfigType(IDnum);
	RatedMatchConfig = spawn(RMI);
	RemainingBots = RatedMatchConfig.NumBots; 
	Difficulty = LadderObj.TournamentDifficulty + RatedMatchConfig.ModifiedDifficulty;
	if ( Difficulty >= 4 )
	{
		bNoviceMode = false;
		Difficulty = Difficulty - 4;
	}
	else
	{
		if ( Difficulty > 3 )
		{
			Difficulty = 3;
			bThreePlus = true;
		}
		bNoviceMode = true;
	}

	// Update GRI
	InitGameReplicationInfo();

	// Update Logged Info
	if (bLocalLog && bLoggingGame)
	{
		LogGameParameters(LocalLog);
	}
	if (bWorldLog && bLoggingGame)
	{
		LogGameParameters(WorldLog);
	}

	PlayStartupMessage(LadderPlayer);
	LadderPlayer.SetProgressTime(6);
}


/* AcceptInventory()
Examine the passed player's inventory, and accept or discard each item
* AcceptInventory needs to gracefully handle the case of some inventory
being accepted but other inventory not being accepted (such as the default
weapon).  There are several things that can go wrong: A weapon's
AmmoType not being accepted but the weapon being accepted -- the weapon
should be killed off. Or the player's selected inventory item, active
weapon, etc. not being accepted, leaving the player weaponless or leaving
the HUD inventory rendering messed up (AcceptInventory should pick another
applicable weapon/item as current).
*/
function AcceptInventory(pawn PlayerPawn)
{
	local inventory Inv;
	local LadderInventory LadderObj;

	// DeathMatchPlus accepts LadderInventory
	for( Inv=PlayerPawn.Inventory; Inv!=None; Inv=Inv.Inventory )
	{
		if (Inv.IsA('LadderInventory'))
		{
			LadderObj = LadderInventory(Inv);
		} 
		else 	
			Inv.Destroy();
	}
	PlayerPawn.Weapon = None;
	PlayerPawn.SelectedItem = None;
	AddDefaultInventory( PlayerPawn );
}

function bool SetEndCams(string Reason)
{
	local pawn P, Best;
	local PlayerPawn Player;

	// find individual winner
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		if ( P.bIsPlayer && !P.IsA('Spectator') && ((Best == None) || (P.PlayerReplicationInfo.Score > Best.PlayerReplicationInfo.Score)) )
			Best = P;

	// check for tie
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		if ( P.bIsPlayer && (Best != P) && (P.PlayerReplicationInfo.Score == Best.PlayerReplicationInfo.Score) )
		{
			BroadcastLocalizedMessage( DMMessageClass, 0 );
			return false;
		}		

	EndTime = Level.TimeSeconds + 3.0;
	US_GRI(GameReplicationInfo).GameEndedComments = Best.PlayerReplicationInfo.PlayerName@GameEndedMessage;
	log( "Game ended at "$EndTime);
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
	{
		Player = PlayerPawn(P);
		if ( Player != None )
		{
			if (!bTutorialGame)
				PlayWinMessage(Player, (Player == Best));
			Player.bBehindView = true;
			if ( Player == Best )
				Player.ViewTarget = None;
			else
				Player.ViewTarget = Best;
			Player.ClientGameEnded();
		}
		P.GotoState('GameEnded');
	}
	CalcEndStats();
	return true;
}

function PlayWinMessage(PlayerPawn Player, bool bWinner)
{
	if ( Player.IsA('TournamentPlayer') )
		TournamentPlayer(Player).PlayWinMessage(bWinner);
}

function NotifySpree(Pawn Other, int num)
{
	local Pawn P;

	if ( num == 5 )
		num = 0;
	else if ( num == 10 )
		num = 1;
	else if ( num == 15 )
		num = 2;
	else if ( num == 20 )
		num = 3;
	else if ( num == 25 )
		num = 4;
	else
		return;

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if ( P.IsA('TournamentPlayer') )
			P.ReceiveLocalizedMessage( class'KillingSpreeMessage', Num, Other.PlayerReplicationInfo );
}

function EndSpree(Pawn Killer, Pawn Other)
{
	local Pawn P;

	if ( !Other.bIsPlayer )
		return;
	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if ( P.IsA('TournamentPlayer') )
		{
			if ( (Killer == None) || !Killer.bIsPlayer )
				TournamentPlayer(P).EndSpree(None, Other.PlayerReplicationInfo);
			else
				TournamentPlayer(P).EndSpree(Killer.PlayerReplicationInfo, Other.PlayerReplicationInfo);
		}
}

function ScoreKill(pawn Killer, pawn Other)
{
	Super.ScoreKill(Killer, Other);

	if ( bAltScoring && (Killer != Other) && (killer != None) )
		Other.PlayerReplicationInfo.Score -= 1;
}

// Monitor killed messages for fraglimit
function Killed(pawn killer, pawn Other, name damageType)
{
local int NextTaunt, i, m;
local bool bAutoTaunt, bEndOverTime;
local Pawn P, Best;

        if ((Killer !=none) && (Other !=none))
        {
	if ( Other == killer && killer.bIsPlayer )
		{
		BroadcastMessage( killer.PlayerReplicationInfo.PlayerName$" terminated his own life.", false );
		}
	else if ( killer == none && Other.bIsPlayer )
		{
		BroadcastMessage( Other.PlayerReplicationInfo.PlayerName$"'s life got terminated.", false );
		}
	else if ( (damageType == 'aura') )
		{
		if ( Other.IsA('US_Monster') )
			{
			BroadcastMessage( US_Monster(Other).MonsterName$" got toasted by"@killer.PlayerReplicationInfo.PlayerName$"'s lethal aura.", false );
			}
		else if ( Other.bIsPlayer )
			{
			BroadcastMessage( Other.PlayerReplicationInfo.PlayerName$" got toasted by"@killer.PlayerReplicationInfo.PlayerName$"'s lethal aura.", false );
			}
		}
	else if ( (damageType == 'Frozen') )
		{
		if ( Other.IsA('US_Monster') )
			{
			BroadcastMessage( US_Monster(Other).MonsterName$" got Frozen by"@killer.PlayerReplicationInfo.PlayerName, false );
			}
		else if ( Other.bIsPlayer )
			{
			BroadcastMessage( Other.PlayerReplicationInfo.PlayerName$" got Frozen by"@killer.PlayerReplicationInfo.PlayerName, false );
			}
		}
	else if ( Other.IsA('US_Monster') && killer.bIsPlayer )
		{
		BroadcastMessage( killer.PlayerReplicationInfo.PlayerName$" terminated "@US_Monster(Other).MonsterName$".", false );
		}
	else if ( killer.IsA('US_Monster') && Other.bIsPlayer )
		{
		BroadcastMessage( US_Monster(killer).MonsterName$" introduced"@Other.PlayerReplicationInfo.PlayerName$" to the reaper.", false );
		}
	else if ( killer.bIsPlayer && Other.bIsPlayer )
		{
		if ( (damageType == 'Decapitated') )
			{
			BroadcastMessage(killer.PlayerReplicationInfo.PlayerName$" seperated "@Other.PlayerReplicationInfo.PlayerName$"'s head from the body.", false );
			}
		else
			{
			BroadcastMessage(killer.PlayerReplicationInfo.PlayerName$" Pwned"@Other.PlayerReplicationInfo.PlayerName$".", false );
			}
		}
	if ( (damageType == 'Decapitated') && (Killer != Other) && (Killer != None) )
		{
		switch(Rand(2))
                	{
			case 0 :
			        Killer.ReceiveLocalizedMessage(class'HeadHunterMessage');
				break;
			default :
				Killer.ReceiveLocalizedMessage(class'HeadShotMessage');
				break;
			}
		}

	/* commented out for testing */
	//Super(GameInfo).Killed(Killer, Other, DamageType);


	if ( Other.Spree > 4 )
		EndSpree(Killer, Other); 
	Other.Spree = 0;

	if ( !bTeamGame )
	{
		if ( bOverTime )
		{
			bEndOverTime = true;
			//check for clear winner now
			// find individual winner
			for ( P=Level.PawnList; P!=None; P=P.nextPawn )
				if ( P.bIsPlayer && ((Best == None) || (P.PlayerReplicationInfo.Score > Best.PlayerReplicationInfo.Score)) )
					Best = P;

			// check for tie
			for ( P=Level.PawnList; P!=None; P=P.nextPawn )
				if ( P.bIsPlayer && (Best != P) && (P.PlayerReplicationInfo.Score == Best.PlayerReplicationInfo.Score) )
					bEndOverTime = false;

			if ( bEndOverTime )
			{
				if ( (FragLimit > 0) && (Best.PlayerReplicationInfo.Score >= FragLimit) )
					{
					DeathMatchPlus(Level.Game).bDontRestart = True;
					EndGame("fraglimit");
					}
				else
					{
					DeathMatchPlus(Level.Game).bDontRestart = True;
					EndGame("timelimit");
					}
			}
		}
		else if ( (FragLimit > 0) && (killer != None) && (killer.PlayerReplicationInfo != None)	&& (killer.PlayerReplicationInfo.Score >= FragLimit) )
			{
			DeathMatchPlus(Level.Game).bDontRestart = True;
			EndGame("fraglimit");
			}
	}
	
	if ( (killer == None) || (Other == None) )
		return;
	if ( !bFirstBlood )
		if ( Killer.bIsPlayer && (Killer != Other) )
			if (!Self.IsA('TrainingDM'))
			{
				bFirstBlood = True;
				BroadcastLocalizedMessage( class'FirstBloodMessage', 0, Killer.PlayerReplicationInfo );
			}

	if ( BotConfig.bAdjustSkill && (killer.IsA('PlayerPawn') || Other.IsA('PlayerPawn')) )
	{
		if ( killer.IsA('Bot') )
			BotConfig.AdjustSkill(Bot(killer),true);
		if ( Other.IsA('Bot') )
			BotConfig.AdjustSkill(Bot(Other),false);
	}
		
	if ( Other.bIsPlayer && (Killer != None) && Killer.bIsPlayer && (Killer != Other) 
		&& (!bTeamGame || (Other.PlayerReplicationInfo.Team != Killer.PlayerReplicationInfo.Team)) )
	{
		Killer.Spree++;
		if ( Killer.Spree > 4 )
			NotifySpree(Killer, Killer.Spree);
	} 

	bAutoTaunt = ((TournamentPlayer(Killer) != None) && TournamentPlayer(Killer).bAutoTaunt);
	if ( ((Bot(Killer) != None) || bAutoTaunt)
		&& (Killer != Other) && (DamageType != 'gibbed') && (Killer.Health > 0)
		&& (Level.TimeSeconds - LastTauntTime > 3) )
	{
		LastTauntTime = Level.TimeSeconds;
		NextTaunt = Rand(class<ChallengeVoicePack>(Killer.PlayerReplicationInfo.VoiceType).Default.NumTaunts);
		for ( i=0; i<4; i++ )
		{
			if ( NextTaunt == LastTaunt[i] )
				NextTaunt = Rand(class<ChallengeVoicePack>(Killer.PlayerReplicationInfo.VoiceType).Default.NumTaunts);
			if ( i > 0 )
				LastTaunt[i-1] = LastTaunt[i];
		}	
		LastTaunt[3] = NextTaunt;
 		killer.SendGlobalMessage(None, 'AUTOTAUNT', NextTaunt, 5);
	}
	if ( bRatedGame )
		RateVs(Other, Killer);
   }		
}

event playerpawn Login
(
	string Portal,
	string Options,
	out string Error,
	class<playerpawn> SpawnClass
)
{
local playerpawn NewPlayer;
local US_PRI IPRI;

	if ( (Level.NetMode != NM_Standalone) && (NumCommanders >= MaxCommanders) && ClassIsChildOf(SpawnClass, class'Commander') )
	{
		Error="Max commanders "$MaxCommanders$" exceeded";
		return None;
	}

	//NewPlayer = Super.Login(Portal, Options, Error, SpawnClass);
	NewPlayer = Super.Login(Portal, Options, Error, Class'BotPack.TMale2');
	US_PRI(NewPlayer.PlayerReplicationInfo).bGrabStats = True;	// hack to ensure that even a reconnecting player visits the database for an update.
	US_PRI(NewPlayer.PlayerReplicationInfo).bChoseCharacter = True;

	if ( NewPlayer != None )
	{
		if ( bRatedGame )
			NewPlayer.AirControl = 0.35;
		else
			NewPlayer.AirControl = AirControl;
		if ( Left(NewPlayer.PlayerReplicationInfo.PlayerName, 6) == DefaultPlayerName )
		{
			if (Level.Game.WorldLog != None)
				Level.Game.WorldLog.LogSpecialEvent("forced_name_change", NewPlayer.PlayerReplicationInfo.PlayerName, NewPlayer.PlayerReplicationInfo.PlayerID, DefaultPlayerName$NumPlayers);
			ChangeName( NewPlayer, ("Soldier"$NumPlayers), false );
		}
		NewPlayer.bAutoActivate = true;
		if ( (bGameEnded || (bRequireReady && (CountDown > 0))) && !NewPlayer.IsA('Spectator') )
			NewPlayer.PlayerRestartState = 'PlayerWaiting';
		else
			NewPlayer.PlayerRestartState = NewPlayer.Default.PlayerRestartState;

		if ( NewPlayer.IsA('TournamentPlayer') )
		{
			TournamentPlayer(NewPlayer).StartSpot = LastStartSpot;
			if ( NewPlayer.IsA('Commander') )
				NumCommanders++;
		}
	}
	return NewPlayer;
}

event PostLogin( playerpawn NewPlayer )
{
	Super.PostLogin(NewPlayer);
	if ( Level.NetMode == NM_Standalone )
	{
		while ( (RemainingBots > 0) && AddBot() )
			RemainingBots--;
	}
	else
		RemainingBots = 0;

	if ( !bRatedGame )
	{
		PlayStartUpMessage(NewPlayer);
		NewPlayer.SetProgressTime(6);
	}
}

function int ReduceDamage(int Damage, name DamageType, pawn injured, pawn instigatedBy)
{

	if (injured.IsA('PlayerPawn'))
		{
		if ( US_PRI(injured.PlayerReplicationInfo).bHasDefense )
			{
			Damage *= 0.5;
			}
		}

	if (injured.Region.Zone.bNeutralZone)
		return 0;

	if ( instigatedBy == None)
		return Damage;

	if ( bHardCoreMode )
		Damage *= 1.5;
	if ( bNoviceMode && !bThreePlus )
	{
		if ( instigatedBy.bIsPlayer && (injured == instigatedby) && (Level.NetMode == NM_Standalone) )
			Damage *= 0.5;

		//skill level modification
		if ( instigatedBy.IsA('Bot') && injured.IsA('PlayerPawn') )
		{
			if ( ((instigatedBy.Weapon != None) && instigatedBy.Weapon.bMeleeWeapon) 
				|| ((injured.Weapon != None) && injured.Weapon.bMeleeWeapon && (VSize(injured.location - instigatedBy.Location) < 600)) )
				Damage = Damage * (0.76 + 0.08 * instigatedBy.skill);
			else
				Damage = Damage * (0.25 + 0.15 * instigatedBy.skill);
		}
	}
	return (Damage * instigatedBy.DamageScaling);
}

/*
function StartMatch()
{	
	local Pawn P;
	local TimedTrigger T;

	if (LocalLog != None)
		LocalLog.LogGameStart();
	if (WorldLog != None)
		WorldLog.LogGameStart();

	ForEach AllActors(class'TimedTrigger', T)
		T.SetTimer(T.DelaySeconds, T.bRepeating);

	if ( Level.NetMode != NM_Standalone )
		RemainingBots = 0;
	US_GRI(GameReplicationInfo).RemainingMinute = RemainingTime;
	bStartMatch = true;

	// start players first (in their current startspots)
	for ( P = Level.PawnList; P!=None; P=P.nextPawn )
		if ( P.bIsPlayer && P.IsA('PlayerPawn') )
		{
			if ( bGameEnded ) return;
			else if ( !P.IsA('Spectator')  )
			{
				P.PlayerRestartState = P.Default.PlayerRestartState;
				P.GotoState(P.Default.PlayerRestartState);
				if ( !P.IsA('Commander') )
				{
					if ( !RestartPlayer(P) )
						P.GotoState('Dying'); //failed to restart player, so let him try to respawn again
				}
			}
			SendStartMessage(PlayerPawn(P));
		}


	for ( P = Level.PawnList; P!=None; P=P.nextPawn )
		if ( P.bIsPlayer && !P.IsA('PlayerPawn') )
		{
			P.RestartPlayer();
			if ( P.IsA('Bot') )
				Bot(P).StartMatch();
		}
	bStartMatch = false;
}
*/

function AddAmmo(NavigationPoint PN)
{
local US_Ammo PA;

	PA = Spawn(Class'US_Ammo',,,PN.Location);
	PA.SetPhysics(PHYS_Falling);
	PA.bCollideWorld = True;
	PA.bRotatingPickup = True;
	PA.DrawScale = 0.5;
	PA.NumAmmoCount = NumAmmoCount;
	PA.MaxAmmoCount = MaxAmmoCount;
}

function PupellaSpawnEnemy(US_Monster P)
{
local float speed;
local US_Monster M;
local Effects FX;

	speed = VSize(P.Velocity);
	FX = Spawn(Class'FlameExplosion',,,P.Location+Vect(0,0,32));
	M = Spawn(Class'US_Monster_PupellaGuard',,,P.Location+Vect(0,0,32));
	M.SetPhysics(PHYS_Falling);
	M.bCollideWorld = true;
	M.Velocity = Normal(P.Velocity/speed + 0.5 * VRand()) * (speed + 320);
	M.GotoState('Attacking');
}

function RockSpawnEnemy(US_Monster P)
{
local float speed;
local US_Monster_RocksGuard M;
local Effects FX;

	speed = VSize(P.Velocity);
	FX = Spawn(Class'FlameExplosion',,,P.Location+Vect(0,0,80));
	M = Spawn(Class'US_Monster_RocksGuard',,,P.Location+Vect(0,0,80));
	M.SetPhysics(PHYS_Falling);
	M.bCollideWorld = true;
	M.Velocity = Normal(P.Velocity/speed + 0.5 * VRand()) * (speed + 440);
	M.GotoState('Attacking');
}

function AliellaSpawnEnemy(US_Monster P)
{
local float speed;
local US_Monster_AliellaGuard M;
local Effects FX;

	speed = VSize(P.Velocity);
	FX = Spawn(Class'FlameExplosion',,,P.Location+Vect(0,0,80));
	M = Spawn(Class'US_Monster_AliellaGuard',,,P.Location+Vect(0,0,80));
	M.SetPhysics(PHYS_Falling);
	M.bCollideWorld = true;
	M.Velocity = Normal(P.Velocity/speed + 0.5 * VRand()) * (speed + 440);
	M.GotoState('Attacking');
}

function TurokSpawnEnemy(US_Monster P)
{
local float speed;
local US_Monster_TurokGuard M;
local Effects FX;

	speed = VSize(P.Velocity);
	FX = Spawn(Class'FlameExplosion',,,P.Location+Vect(0,0,80));
	M = Spawn(Class'US_Monster_TurokGuard',,,P.Location+Vect(0,0,80));
	//M.SetPhysics(PHYS_Falling);
	M.bCollideWorld = true;
	M.Velocity = Normal(P.Velocity/speed + 0.5 * VRand()) * (speed + 440);
	M.GotoState('Attacking');
}

function HellSniperSpawnEnemy(US_Monster P)
{
local float speed;
local US_Monster_HSGuard M;
local Effects FX;

	if ( HSdice == 0 )
		{
		FX = Spawn(Class'FlameExplosion',,,P.Location+Vect(50,50,-20));
		M = Spawn(Class'US_Monster_HSGuard',,,P.Location+Vect(50,50,-20));
		}
	else if ( HSdice == 1 )
		{
		FX = Spawn(Class'FlameExplosion',,,P.Location+Vect(-50,50,-20));
		M = Spawn(Class'US_Monster_HSGuard',,,P.Location+Vect(-50,50,-20));
		}
	else if ( HSdice == 2 )
		{
		FX = Spawn(Class'FlameExplosion',,,P.Location+Vect(-50,-50,-20));
		M = Spawn(Class'US_Monster_HSGuard',,,P.Location+Vect(-50,-50,-20));
		}
	else if ( HSdice == 3 )
		{
		FX = Spawn(Class'FlameExplosion',,,P.Location+Vect(50,-50,-20));
		M = Spawn(Class'US_Monster_HSGuard',,,P.Location+Vect(50,-50,-20));
		}
	else if ( HSdice == 4 )
		{
		FX = Spawn(Class'FlameExplosion',,,P.Location+Vect(0,-50,-20));
		M = Spawn(Class'US_Monster_HSGuard',,,P.Location+Vect(0,-50,-20));
		}
	else if ( HSdice == 5 )
		{
		FX = Spawn(Class'FlameExplosion',,,P.Location+Vect(50,0,-20));
		M = Spawn(Class'US_Monster_HSGuard',,,P.Location+Vect(50,0,-20));
		}
	else if ( HSdice == 6 )
		{
		FX = Spawn(Class'FlameExplosion',,,P.Location+Vect(0,50,-20));
		M = Spawn(Class'US_Monster_HSGuard',,,P.Location+Vect(0,50,-20));
		}
	else
		{
		FX = Spawn(Class'FlameExplosion',,,P.Location+Vect(-50,0,-20));
		M = Spawn(Class'US_Monster_HSGuard',,,P.Location+Vect(-50,0,-20));
		}
	HSdice++;
	if ( HSdice > 7 )
		HSdice = 0;
}

function Timer()
{
local Pawn P;
local bool bReady;
local int M;
local int Pnum;
//monster variables:
local int PointCount, Monsters, NavPoint;
local NavigationPoint NP;
//Ammo variables
local US_Ammo PA;
local int Pickups;
local bool bBossPresent;
local string BossName;
local US_Monster Boss;

	ForEach AllActors(class'US_Ammo', PA)
		{
		Pickups++;
		}

	Super.Timer();

	Pnum = 0;
	Monsters = 0;
	bBossPresent = False;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn') || P.IsA('Bot') )
			{
			if ( !P.PlayerReplicationInfo.bIsSpectator )
				{
				Pnum++;
				}
			}
		else if ( P.IsA('ScriptedPawn') )
			{
			Monsters++;
			if ( P.IsA('US_Boss_Pupella') )
				{
				bBossPresent = True;
				BossName = "Pupella";
				Boss = US_Monster(P);
				}
			else if ( P.IsA('US_Boss_TheRock') )
				{
				bBossPresent = True;
				BossName = "TheRock";
				Boss = US_Monster(P);
				}
			else if ( P.IsA('US_Boss_Aliella') )
				{
				bBossPresent = True;
				BossName = "Aliella";
				Boss = US_Monster(P);
				}
			else if ( P.IsA('US_Boss_Turok') )
				{
				bBossPresent = True;
				BossName = "Turok";
				Boss = US_Monster(P);
				}
			else if ( P.IsA('US_Boss_HellSniper') )
				{
				bBossPresent = True;
				BossName = "HellSniper";
				Boss = US_Monster(P);
				}
			}
		}

	if ( bBossPresent && Monsters < MaxMonsters)
		{
		if ( BossName == "Pupella" )
			{
			PupellaSpawnEnemy(Boss);
			}
		else if ( BossName == "TheRock" )
			{
			RockSpawnEnemy(Boss);
			}
		else if ( BossName == "Aliella" )
			{
			AliellaSpawnEnemy(Boss);
			}
		else if ( BossName == "Turok" )
			{
			TurokSpawnEnemy(Boss);
			}
		else if ( BossName == "HellSniper" )
			{
			HellSniperSpawnEnemy(Boss);
			}
		}

	US_GRI(GameReplicationInfo).NumSoldiers = Pnum;
	US_GRI(GameReplicationInfo).NumMonsters = Monsters;

	if ( Monsters < NumMonsters )
		{
		NavPoint = Rand(NumPoints);
		for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
			{
			if ( NP.IsA('PathNode') )
				{
				if (PointCount == NavPoint)
					{
					AddMonster(NP);
					}
				PointCount++;
				}
			}
		}

	if ( SecondsToKillBoss != 0 && US_GRI(GameReplicationInfo).RemainingTime <= SecondsToKillBoss && !bBossSpawned )
		{
		NavPoint = Rand(NumPoints);
		for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
			{
			if ( NP.IsA('PathNode') )
				{
				if (PointCount == NavPoint)
					{
					AddBoss(NP);
					bBossSpawned = True;
					}
				PointCount++;
				}
			}
		}

	if ( Pickups < NumAmmoPickups )
		{
		NavPoint = Rand(NumPoints);
		for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
			{
			if ( NP.IsA('PathNode') )
				{
				if (PointCount == NavPoint)
					{
					AddAmmo(NP);
					}
				PointCount++;
				}
			}
		}


	if ( bNetReady )
	{
		if ( NumPlayers > 0 )
			ElapsedTime++;
		else
			ElapsedTime = 0;
		if ( ElapsedTime > NetWait )
		{
			if ( (NumPlayers + NumBots < 4) && NeedPlayers() )
				AddBot();
			else if ( (NumPlayers + NumBots > 1) || ((NumPlayers > 0) && (ElapsedTime > 2 * NetWait)) )
				bNetReady = false;
		}

		if ( bNetReady )
		{
			for (P=Level.PawnList; P!=None; P=P.NextPawn )
				if ( P.IsA('PlayerPawn') )
					PlayerPawn(P).SetProgressTime(2);
			return;
		}
		else
		{
			while ( NeedPlayers() )
				AddBot();
			bRequireReady = false;

			/* commented out to remove the damn annoying forced respawn after 10 seconds
			StartMatch();
			*/
		}
	}

	if ( bRequireReady && (CountDown > 0) )
	{
		while ( (RemainingBots > 0) && AddBot() )
			RemainingBots--;
		for (P=Level.PawnList; P!=None; P=P.NextPawn )
			if ( P.IsA('PlayerPawn') )
				PlayerPawn(P).SetProgressTime(2);
		if ( ((NumPlayers == MaxPlayers) || (Level.NetMode == NM_Standalone)) 
				&& (RemainingBots <= 0) )
		{	
			bReady = true;
			for (P=Level.PawnList; P!=None; P=P.NextPawn )
				if ( P.IsA('PlayerPawn') && !P.IsA('Spectator')
					&& !PlayerPawn(P).bReadyToPlay )
					bReady = false;
			
			if ( bReady )
			{	
				StartCount = 30;
				CountDown--;
				if ( CountDown <= 0 )
					StartMatch();
				else
				{
					for ( P = Level.PawnList; P!=None; P=P.nextPawn )
						if ( P.IsA('PlayerPawn') )
						{
							PlayerPawn(P).ClearProgressMessages();
							if ( (CountDown < 11) && P.IsA('TournamentPlayer') )
								TournamentPlayer(P).TimeMessage(CountDown);
							else
								PlayerPawn(P).SetProgressMessage(CountDown$CountDownMessage, 0);
						}
				}
			}
			else if ( StartCount > 8 ) 
			{
				for ( P = Level.PawnList; P!=None; P=P.nextPawn )
					if ( P.IsA('PlayerPawn') )
					{
						PlayerPawn(P).ClearProgressMessages();
						PlayerPawn(P).SetProgressTime(2);
						PlayerPawn(P).SetProgressMessage(WaitingMessage1, 0);
						PlayerPawn(P).SetProgressMessage(WaitingMessage2, 1);
						if ( PlayerPawn(P).bReadyToPlay )
							PlayerPawn(P).SetProgressMessage(ReadyMessage, 2);
						else
							PlayerPawn(P).SetProgressMessage(NotReadyMessage, 2);
					}
			}
			else
			{
				StartCount++;
				if ( Level.NetMode != NM_Standalone )
					StartCount = 30;
			}
		}
		else
		{
			for ( P = Level.PawnList; P!=None; P=P.nextPawn )
				if ( P.IsA('PlayerPawn') )
					PlayStartupMessage(PlayerPawn(P));
		}
	}	
	else
	{
		if ( bAlwaysForceRespawn || (bForceRespawn && (Level.NetMode != NM_Standalone)) )
			For ( P=Level.PawnList; P!=None; P=P.NextPawn )
			{
				if ( P.IsInState('Dying') && P.IsA('PlayerPawn') && P.bHidden )
					PlayerPawn(P).ServerReStartPlayer();
			}
		if ( Level.NetMode != NM_Standalone )
		{
			if ( NeedPlayers() )
				AddBot();
		}
		else
			while ( (RemainingBots > 0) && AddBot() )
				RemainingBots--;
		if ( bGameEnded )
		{
			if ( Level.TimeSeconds > EndTime + RestartWait )
				RestartGame();
		}
		else if ( !bOverTime && (TimeLimit > 0) )
		{
			US_GRI(GameReplicationInfo).bStopCountDown = false;
			RemainingTime--;
			US_GRI(GameReplicationInfo).RemainingTime = RemainingTime;
			if ( RemainingTime % 60 == 0 )
				US_GRI(GameReplicationInfo).RemainingMinute = RemainingTime;
			if ( RemainingTime <= 0 )
				EndGame("timelimit");
		}
		else
		{
			ElapsedTime++;
			US_GRI(GameReplicationInfo).ElapsedTime = ElapsedTime;
		}
	}
}

function AddBoss(NavigationPoint PN)
{
local ScriptedPawn SP;
local int monster;
local Pawn P;
	
	//Spawn random boss:
	monster = Rand(5);

	if ( monster == 0 )
		{
		SP = Spawn(Class'US_Boss_Aliella',,,PN.Location+Vect(0,0,32));
		for ( P = Level.PawnList; P!=None; P=P.nextPawn )
			{
			if ( P.IsA('PlayerPawn') )
				{
				P.ReceiveLocalizedMessage(class'Message_Boss_Aliella');
				}
			}
		}
	else if ( monster == 1 )
		{
		SP = Spawn(Class'US_Boss_Pupella',,,PN.Location+Vect(0,0,32));
		for ( P = Level.PawnList; P!=None; P=P.nextPawn )
			{
			if ( P.IsA('PlayerPawn') )
				{
				P.ReceiveLocalizedMessage(class'Message_Boss_Pupella');
				}
			}
		}
	else if ( monster == 2 )
		{
		SP = Spawn(Class'US_Boss_Turok',,,PN.Location+Vect(0,0,32));
		for ( P = Level.PawnList; P!=None; P=P.nextPawn )
			{
			if ( P.IsA('PlayerPawn') )
				{
				P.ReceiveLocalizedMessage(class'Message_Boss_Turok');
				}
			}
		}
	else if ( monster == 3 )
		{
		SP = Spawn(Class'US_Boss_HellSniper',,,PN.Location+Vect(0,0,32));
		for ( P = Level.PawnList; P!=None; P=P.nextPawn )
			{
			if ( P.IsA('PlayerPawn') )
				{
				P.ReceiveLocalizedMessage(class'Message_Boss_HellSniper');
				}
			}
		}
	else
		{
		SP = Spawn(Class'US_Boss_TheRock',,,PN.Location+Vect(0,0,32));
		for ( P = Level.PawnList; P!=None; P=P.nextPawn )
			{
			if ( P.IsA('PlayerPawn') )
				{
				P.ReceiveLocalizedMessage(class'Message_Boss_TheRock');
				}
			}
		}
	SP.SetPhysics(PHYS_Falling);

	
}

function AddMonster(NavigationPoint PN)
{
local ScriptedPawn SP;
local int monster;

			//Test monster:
			//SP = Spawn(Class'US_Monster_Slith4',,,PN.Location+Vect(0,0,32));
			//SP = Spawn(Class'US_Boss_HellSniper',,,PN.Location+Vect(0,0,64));
			//SP = Spawn(Class'US_Boss_Pupella',,,PN.Location+Vect(0,0,32));
		
			//Spawn random monster:
			monster = Rand(34);

			if ( monster == 0 )
				{
				SP = Spawn(Class'US_Monster_Brute',,,PN.Location);
				}
			else if ( monster == 1 )
				{
				SP = Spawn(Class'US_Monster_CaveManta',,,PN.Location);
				}
			else if ( monster == 2 )
				{
				SP = Spawn(Class'US_Monster_Fly',,,PN.Location);
				}
			else if ( monster == 3 )
				{
				SP = Spawn(Class'US_Monster_LesserBrute',,,PN.Location);
				}
			else if ( monster == 4 )
				{
				SP = Spawn(Class'US_Monster_Manta',,,PN.Location);
				}
			else if ( monster == 5 )
				{
				SP = Spawn(Class'US_Monster_SkaarjScout',,,PN.Location);
				}
			else if ( monster == 6 )
				{
				SP = Spawn(Class'US_Monster_WarLord',,,PN.Location);
				}
			else if ( monster == 7 )
				{
				SP = Spawn(Class'US_Monster_SkaarjWarrior',,,PN.Location);
				}
			else if ( monster == 8 )
				{
				SP = Spawn(Class'US_Monster_Slith',,,PN.Location);
				}
			else if ( monster == 9 )
				{
				SP = Spawn(Class'US_Monster_Behemoth',,,PN.Location);
				}
			else if ( monster == 10 )
				{
				SP = Spawn(Class'US_Monster_Gasbag',,,PN.Location);
				}
			else if ( monster == 11 )
				{
				SP = Spawn(Class'US_Monster_IceSkaarj',,,PN.Location);
				}
			else if ( monster == 12 )
				{
				SP = Spawn(Class'US_Monster_Krall',,,PN.Location);
				}
			else if ( monster == 13 )
				{
				SP = Spawn(Class'US_Monster_KrallElite',,,PN.Location);
				}
			else if ( monster == 14 )
				{
				SP = Spawn(Class'US_Monster_Mercenary',,,PN.Location);
				}
			else if ( monster == 15 )
				{
				SP = Spawn(Class'US_Monster_MercenaryElite',,,PN.Location);
				}
			else if ( monster == 16 )
				{
				SP = Spawn(Class'US_Monster_Pupae',,,PN.Location);
				}
			else if ( monster == 17 )
				{
				SP = Spawn(Class'US_Monster_Queen',,,PN.Location);
				}
			else if ( monster == 18 )
				{
				SP = Spawn(Class'US_Monster_SkaarjAssassin',,,PN.Location);
				}
			else if ( monster == 19 )
				{
				SP = Spawn(Class'US_Monster_SkaarjBerserker',,,PN.Location);
				}
			else if ( monster == 20 )
				{
				SP = Spawn(Class'US_Monster_SkaarjGunner',,,PN.Location);
				}
			else if ( monster == 21 )
				{
				SP = Spawn(Class'US_Monster_SkaarjInfantry',,,PN.Location);
				}
			else if ( monster == 22 )
				{
				SP = Spawn(Class'US_Monster_SkaarjLord',,,PN.Location);
				}
			else if ( monster == 23 )
				{
				SP = Spawn(Class'US_Monster_SkaarjOfficer',,,PN.Location);
				}
			else if ( monster == 24 )
				{
				SP = Spawn(Class'US_Monster_SkaarjSniper',,,PN.Location);
				}
			else if ( monster == 25 )
				{
				SP = Spawn(Class'US_Monster_SkaarjTrooper',,,PN.Location);
				}
			else if ( monster == 26 )
				{
				SP = Spawn(Class'US_Monster_StoneTitan',,,PN.Location);
				}
			else if ( monster == 27 )
				{
				SP = Spawn(Class'US_Monster_Titan',,,PN.Location);
				}
			else if ( monster == 28 )
				{
				SP = Spawn(Class'US_Monster_Slith2',,,PN.Location);
				}
			else if ( monster == 29 )
				{
				SP = Spawn(Class'US_Monster_Slith3',,,PN.Location);
				}
			else if ( monster == 30 )
				{
				SP = Spawn(Class'US_Monster_Slith4',,,PN.Location);
				}
			else if ( monster == 31 )
				{
				SP = Spawn(Class'US_Monster_WarLord2',,,PN.Location);
				}
			else if ( monster == 32 )
				{
				SP = Spawn(Class'US_Monster_WarLord3',,,PN.Location);
				}
			else if ( monster == 33 )
				{
				SP = Spawn(Class'US_Monster_Titan2',,,PN.Location);
				}
}

function bool TooManyBots()
{
	return (NumBots + NumPlayers > MinPlayers);
}

function bool RestartPlayer( pawn aPlayer )	
{
local NavigationPoint startSpot;
local bool foundStart;
local Bot B;
local US_PRI IPRI;

	if( bRestartLevel && Level.NetMode!=NM_DedicatedServer && Level.NetMode!=NM_ListenServer )
		return true;

	startSpot = FindPlayerStart(aPlayer, 255);
	if( startSpot == None )
	{
		log(" Player start not found!!!");
		return false;
	}	
	foundStart = aPlayer.SetLocation(startSpot.Location);
	if( foundStart )
	{
		startSpot.PlayTeleportEffect(aPlayer, true);
		aPlayer.SetRotation(startSpot.Rotation);
		aPlayer.ViewRotation = aPlayer.Rotation;
		aPlayer.Acceleration = vect(0,0,0);
		aPlayer.Velocity = vect(0,0,0);
		if (aPlayer.IsA('PlayerPawn'))
			aPlayer.Health = US_PRI(aPlayer.PlayerReplicationInfo).BaseHealth;
		else
			aPlayer.Health = aPlayer.Default.Health;
		aPlayer.SetCollision( true, true, true );
		aPlayer.ClientSetLocation( startSpot.Location, startSpot.Rotation );
		aPlayer.bHidden = false;
		aPlayer.DamageScaling = aPlayer.Default.DamageScaling;
		aPlayer.SoundDampening = aPlayer.Default.SoundDampening;
		AddDefaultInventory(aPlayer);
	}
	else
		log(startspot$" Player start not useable!!!");
	return foundStart;
}



function SendStartMessage(PlayerPawn P)
{
	P.ClearProgressMessages();
	P.SetProgressMessage(StartMessage, 0);
}

function Bot SpawnBot(out NavigationPoint StartSpot)
{
	local bot NewBot;
	local int BotN;
	local Pawn P;

	if ( bRatedGame )
		return SpawnRatedBot(StartSpot);

	Difficulty = BotConfig.Difficulty;

	if ( Difficulty >= 4 )
	{
		bNoviceMode = false;
		Difficulty = Difficulty - 4;
	}
	else
	{
		if ( Difficulty > 3 )
		{
			Difficulty = 3;
			bThreePlus = true;
		}
		bNoviceMode = true;
	}
	BotN = BotConfig.ChooseBotInfo();
	
	// Find a start spot.
	StartSpot = FindPlayerStart(None, 255);
	if( StartSpot == None )
	{
		log("Could not find starting spot for Bot");
		return None;
	}

	// Try to spawn the bot.
	NewBot = Spawn(BotConfig.CHGetBotClass(BotN),,,StartSpot.Location,StartSpot.Rotation);

	if ( NewBot == None )
		log("Couldn't spawn player at "$StartSpot);

	if ( (bHumansOnly || Level.bHumansOnly) && !NewBot.bIsHuman )
	{
		log("can't add non-human bot to this game");
		NewBot.Destroy();
		NewBot = None;
	}

	if ( NewBot == None )
		NewBot = Spawn(BotConfig.CHGetBotClass(0),,,StartSpot.Location,StartSpot.Rotation);

	if ( NewBot != None )
	{
		// Set the player's ID.
		NewBot.PlayerReplicationInfo.PlayerID = CurrentID++;

		NewBot.PlayerReplicationInfo.Team = BotConfig.GetBotTeam(BotN);
		BotConfig.CHIndividualize(NewBot, BotN, NumBots);
		NewBot.ViewRotation = StartSpot.Rotation;
		// broadcast a welcome message.
		BroadcastMessage( NewBot.PlayerReplicationInfo.PlayerName$EnteredMessage, false );

		ModifyBehaviour(NewBot);
		AddDefaultInventory( NewBot );
		NumBots++;
		if ( bRequireReady && (CountDown > 0) )
			NewBot.GotoState('Dying', 'WaitingForStart');
		NewBot.AirControl = AirControl;

		if ( (Level.NetMode != NM_Standalone) && (bNetReady || bRequireReady) )
		{
			// replicate skins
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
				if ( P.bIsPlayer && (P.PlayerReplicationInfo != None) && P.PlayerReplicationInfo.bWaitingPlayer && P.IsA('PlayerPawn') )
				{
					if ( NewBot.bIsMultiSkinned )
						PlayerPawn(P).ClientReplicateSkins(NewBot.MultiSkins[0], NewBot.MultiSkins[1], NewBot.MultiSkins[2], NewBot.MultiSkins[3]);
					else
						PlayerPawn(P).ClientReplicateSkins(NewBot.Skin);	
				}						
		}
	}

	return NewBot;
}

function Bot SpawnRatedBot(out NavigationPoint StartSpot)
{
	local bot NewBot;
	local int BotN;
	local bool bEnemy;

	if (RemainingBots > RatedMatchConfig.NumAllies)
		bEnemy = True;

	BotN = RatedMatchConfig.ChooseBotInfo(bTeamGame, bEnemy);
	
	// Find a start spot.
	StartSpot = FindPlayerStart(None, 255);
	if( StartSpot == None )
	{
		log("Could not find starting spot for Bot");
		return None;
	}

	// Try to spawn the bot.
	NewBot = Spawn(RatedMatchConfig.GetBotClass(BotN, bTeamGame, bEnemy, RatedPlayer),,,StartSpot.Location,StartSpot.Rotation);
	if ( NewBot == None )
	{
		if ( (RatedMatchConfig.EnemyTeam == class'RatedTeamInfo7')
			|| (RatedMatchConfig.EnemyTeam == class'RatedTeamInfo8') )
			RatedMatchConfig.EnemyTeam = class'RatedTeamInfo3';
		log("Couldn't spawn player at "$StartSpot);
	}

	if ( NewBot != None )
	{
		// Set the player's ID.
		NewBot.PlayerReplicationInfo.PlayerID = CurrentID++;
	
		RatedMatchConfig.Individualize(NewBot, BotN, NumBots, bTeamGame, bEnemy);
		NewBot.ViewRotation = StartSpot.Rotation;
		// broadcast a welcome message.
		BroadcastMessage( NewBot.PlayerReplicationInfo.PlayerName$EnteredMessage, false );

		ModifyBehaviour(NewBot);
		AddDefaultInventory( NewBot );
		NumBots++;
		if ( bRequireReady && (CountDown > 0) )
			NewBot.GotoState('Dying', 'WaitingForStart');
		NewBot.AirControl = 0.35;
	}

	return NewBot;
}

function bool ForceAddBot()
{
	// add bot during gameplay
	if ( Level.NetMode != NM_Standalone )
		MinPlayers = Max(MinPlayers+1, NumPlayers + NumBots + 1);
	AddBot();
}
		
function bool AddBot()
{
	local bot NewBot;
	local NavigationPoint StartSpot;

	NewBot = SpawnBot(StartSpot);

	if ( NewBot == None )
	{
		log("Failed to spawn bot.");
		return false;
	}

	StartSpot.PlayTeleportEffect(NewBot, true);

	NewBot.PlayerReplicationInfo.bIsABot = True;
	
	// Log it.
	if (LocalLog != None)
	{
		LocalLog.LogPlayerConnect(NewBot);
		LocalLog.FlushLog();
	}
	if (WorldLog != None)
	{
		WorldLog.LogPlayerConnect(NewBot);
		WorldLog.FlushLog();
	}

	return true;
}

function ModifyBehaviour(Bot NewBot);

function PlayStartUpMessage(PlayerPawn NewPlayer)
{
	local int i;

	NewPlayer.ClearProgressMessages();

	// Game Name
	NewPlayer.SetProgressMessage(GameName, i++);

	// Optional FragLimit
	if ( fraglimit > 0 )
		NewPlayer.SetProgressMessage(FragLimit@GameGoal, i++);

	if ( Level.NetMode == NM_Standalone )
		NewPlayer.SetProgressMessage(SingleWaitingMessage, i++);
	else if ( bRequireReady )
		NewPlayer.SetProgressMessage(TourneyMessage, i++);
}

function float PlayerJumpZScaling()
{

	return 1.1;

}

function AddDefaultInventory( pawn PlayerPawn )
{
local int i;
local US_PRI IPRI;
local Inventory Inv;
local UniversalSoldiersWeapon USW;

	GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_ChainSaw");

	if ( PlayerPawn.IsA('Bot'))
		{

		//adjust bot health to difficulty level:
		PlayerPawn.Health = 50 + (50 * GameDifficulty);

		i = Rand(9);
		if ( i == 0 )
			{
			GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_Enforcer");
			}
		else if ( i == 1 )
			{
			GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_MiniGun");
			}
		else if ( i == 2 )
			{
			GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_PulseGun");
			}
		else if ( i == 3 )
			{
			GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_RazorJack");
			}
		else if ( i == 4 )
			{
			GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_ShockRifle");
			}
		else if ( i == 5 )
			{
			GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_SniperRifle");
			}
		else if ( i == 6 )
			{
			GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_BioRifle");
			}
		else if ( i == 7 )
			{
			GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_Eightball");
			}
		else if ( i == 8 )
			{
			GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_FlakCannon");
			}
		}

	else if ( PlayerPawn.IsA('PlayerPawn'))
		{

		//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_Barret50");

		if ( US_PRI(PlayerPawn(PlayerPawn).PlayerReplicationInfo).PlayerModel == "Freezy" )
			{
			USW = Spawn(Class'USW_ShockRifle');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_ShockRifle");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 50;
			}
		else if ( US_PRI(PlayerPawn(PlayerPawn).PlayerReplicationInfo).PlayerModel == "Gordon" )
			{
			USW = Spawn(Class'USW_PulseGun');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_PulseGun");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 100;
			}
		else if ( US_PRI(PlayerPawn(PlayerPawn).PlayerReplicationInfo).PlayerModel == "Ninja" )
			{
			USW = Spawn(Class'USW_BioRifle');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_BioRifle");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 80;
			}
		else if ( US_PRI(PlayerPawn(PlayerPawn).PlayerReplicationInfo).PlayerModel == "Cyclop" )
			{
			USW = Spawn(Class'USW_Eightball');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_Eightball");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 50;
			}
		else if ( US_PRI(PlayerPawn(PlayerPawn).PlayerReplicationInfo).PlayerModel == "Tensor" )
			{
			USW = Spawn(Class'USW_ShockRifle');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_ShockRifle");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 50;
			}
		else if ( US_PRI(PlayerPawn(PlayerPawn).PlayerReplicationInfo).PlayerModel == "Vampire" )
			{
			USW = Spawn(Class'USW_RazorJack');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_RazorJack");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 75;
			}
		else if ( US_PRI(PlayerPawn(PlayerPawn).PlayerReplicationInfo).PlayerModel == "Trooper" )
			{
			USW = Spawn(Class'USW_FlakCannon');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_FlakCannon");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 50;
			}
		else if ( US_PRI(PlayerPawn(PlayerPawn).PlayerReplicationInfo).PlayerModel == "Snake" )
			{
			USW = Spawn(Class'USW_MiniGun');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_MiniGun");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 200;
			}
		else if ( US_PRI(PlayerPawn(PlayerPawn).PlayerReplicationInfo).PlayerModel == "Hitman" )
			{
			USW = Spawn(Class'USW_SniperRifle');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_SniperRifle");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 50;
			}
		else if ( US_PRI(PlayerPawn(PlayerPawn).PlayerReplicationInfo).PlayerModel == "Cyborg" )
			{
			USW = Spawn(Class'USW_Enforcer');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_Enforcer");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 100;
			}
		//Assign Translocator:
		if ( US_PRI(PlayerPawn.PlayerReplicationInfo).Item1 == "Translocator" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item2 == "Translocator" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item3 == "Translocator" )
			{
			USW = Spawn(Class'USW_Translocator');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_Translocator");
			}
		//Assign Grapple Hook:
		if ( US_PRI(PlayerPawn.PlayerReplicationInfo).Item1 == "Grapple" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item2 == "Grapple" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item3 == "Grapple" )
			{
			USW = Spawn(Class'USW_GrappleHook');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_GrappleHook");
			}
		//Assign AssaultRifle:
		if ( US_PRI(PlayerPawn.PlayerReplicationInfo).Item1 == "AssaultRifle" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item2 == "AssaultRifle" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item3 == "AssaultRifle" )
			{
			USW = Spawn(Class'USW_AssaultRifle');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_AssaultRifle");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 75;
			}
		//Assign Enforcer:
		if ( US_PRI(PlayerPawn.PlayerReplicationInfo).Item1 == "Enforcer" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item2 == "Enforcer" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item3 == "Enforcer" )
			{
			USW = Spawn(Class'USW_Enforcer');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_Enforcer");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 100;
			}
		//Assign DoubleEnforcer:
		if ( US_PRI(PlayerPawn.PlayerReplicationInfo).Item1 == "DoubleEnforcer" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item2 == "DoubleEnforcer" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item3 == "DoubleEnforcer" )
			{
			Inv = Spawn(class'USW_Enforcer');
			if ( USW_Enforcer(Inv) != None )
				{
				PlayerPawn.Inventory.HandlePickupQuery( Inv );
				}
			Inv.Destroy();
			}
		//Assign SniperRifle:
		if ( US_PRI(PlayerPawn.PlayerReplicationInfo).Item1 == "SniperRifle" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item2 == "SniperRifle" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item3 == "SniperRifle" )
			{
			USW = Spawn(Class'USW_SniperRifle');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_SniperRifle");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 50;
			}
		//Assign ShockRifle:
		if ( US_PRI(PlayerPawn.PlayerReplicationInfo).Item1 == "ShockRifle" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item2 == "ShockRifle" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item3 == "ShockRifle" )
			{
			USW = Spawn(Class'USW_ShockRifle');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_ShockRifle");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 50;
			}
		//Assign BioRifle:
		if ( US_PRI(PlayerPawn.PlayerReplicationInfo).Item1 == "BioRifle" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item2 == "BioRifle" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item3 == "BioRifle" )
			{
			USW = Spawn(Class'USW_BioRifle');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_BioRifle");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 80;
			}
		//Assign Eightball:
		if ( US_PRI(PlayerPawn.PlayerReplicationInfo).Item1 == "Eightball" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item2 == "Eightball" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item3 == "Eightball" )
			{
			USW = Spawn(Class'USW_Eightball');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_Eightball");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 50;
			}
		//Assign FlakCannon:
		if ( US_PRI(PlayerPawn.PlayerReplicationInfo).Item1 == "FlakCannon" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item2 == "FlakCannon" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item3 == "FlakCannon" )
			{
			USW = Spawn(Class'USW_FlakCannon');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_FlakCannon");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 50;
			}
		//Assign Minigun:
		if ( US_PRI(PlayerPawn.PlayerReplicationInfo).Item1 == "Minigun" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item2 == "Minigun" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item3 == "Minigun" )
			{
			USW = Spawn(Class'USW_Minigun');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_Minigun");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 200;
			}
		//Assign Pulsegun:
		if ( US_PRI(PlayerPawn.PlayerReplicationInfo).Item1 == "Pulsegun" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item2 == "Pulsegun" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item3 == "Pulsegun" )
			{
			USW = Spawn(Class'USW_Pulsegun');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_Pulsegun");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 100;
			}
		//Assign RazorJack:
		if ( US_PRI(PlayerPawn.PlayerReplicationInfo).Item1 == "RazorJack" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item2 == "RazorJack" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item3 == "RazorJack" )
			{
			USW = Spawn(Class'USW_RazorJack');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_RazorJack");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 75;
			}
		//Assign Lawgiver:
		if ( US_PRI(PlayerPawn.PlayerReplicationInfo).Item1 == "Lawgiver" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item2 == "Lawgiver" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item3 == "Lawgiver" )
			{
			USW = Spawn(Class'USW_Lawgiver');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_Lawgiver");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 100;
			}
		//Assign DoubleLawgiver:
		if ( US_PRI(PlayerPawn.PlayerReplicationInfo).Item1 == "DoubleLawgiver" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item2 == "DoubleLawgiver" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item3 == "DoubleLawgiver" )
			{
			Inv = Spawn(class'USW_Lawgiver');
			if ( USW_Lawgiver(Inv) != None )
				{
				PlayerPawn.Inventory.HandlePickupQuery( Inv );
				}
			Inv.Destroy();
			}
		//Assign Painless:
		if ( US_PRI(PlayerPawn.PlayerReplicationInfo).Item1 == "Painless" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item2 == "Painless" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item3 == "Painless" )
			{
			USW = Spawn(Class'USW_Painless');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_Painless");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 200;
			}
		//Assign TwinLauncher:
		if ( US_PRI(PlayerPawn.PlayerReplicationInfo).Item1 == "TwinLauncher" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item2 == "TwinLauncher" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item3 == "TwinLauncher" )
			{
			USW = Spawn(Class'USW_TwinLauncher');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_TwinLauncher");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 75;
			}
		//Assign Uzi:
		if ( US_PRI(PlayerPawn.PlayerReplicationInfo).Item1 == "Uzi" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item2 == "Uzi" || US_PRI(PlayerPawn.PlayerReplicationInfo).Item3 == "Uzi" )
			{
			USW = Spawn(Class'USW_Uzi');
			USW.GiveTo(PlayerPawn);
			//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_Uzi");
			if ( PlayerPawn.Weapon.AmmoType != None )
				PlayerPawn.Weapon.AmmoType.AmmoAmount = 250;
			}
		//Assign BaseArmor:
		if ( US_PRI(PlayerPawn.PlayerReplicationInfo).BaseArmor > 0 )
			{
			Inv = Spawn(class'Armor2');
			Inv.Charge = US_PRI(PlayerPawn.PlayerReplicationInfo).BaseArmor;
			Inv.bIsAnArmor = True;
			inv.GiveTo(PlayerPawn);
			}
		//added to test weapons and items:
		//GiveWeapon(PlayerPawn,"UniversalSoldiers.USW_GrappleHook");
		}
}	



function GiveWeapon(Pawn PlayerPawn, string aClassName )
{
local class<UniversalSoldiersWeapon> WeaponClass;
local UniversalSoldiersWeapon NewWeapon;
local US_PRI IPRI;

	if ( PlayerPawn.IsA('PlayerPawn') && US_PRI(PlayerPawn.PlayerReplicationInfo).bChoseCharacter )
		Return;

	WeaponClass = class<UniversalSoldiersWeapon>(DynamicLoadObject(aClassName, class'Class'));

	if( PlayerPawn.FindInventoryType(WeaponClass) != None )
		return;
	newWeapon = Spawn(WeaponClass);
	if( newWeapon != None )
	{
		newWeapon.RespawnTime = 0.0;
		newWeapon.GiveTo(PlayerPawn);
		newWeapon.bHeldItem = true;
		newWeapon.GiveAmmo(PlayerPawn);
		newWeapon.SetSwitchPriority(PlayerPawn);
		newWeapon.WeaponSet(PlayerPawn);
		newWeapon.AmbientGlow = 0;
		if ( PlayerPawn.IsA('PlayerPawn') )
			newWeapon.SetHand(PlayerPawn(PlayerPawn).Handedness);
		else
			newWeapon.GotoState('Idle');
		PlayerPawn.Weapon.GotoState('DownWeapon');
		PlayerPawn.PendingWeapon = None;
		PlayerPawn.Weapon = newWeapon;
	}
}
	
function byte AssessBotAttitude(Bot aBot, Pawn Other)
{
	local float skillmod;

	if ( bNoviceMode )
		skillmod = 0.3;
	else
		skillmod = 0.2 - aBot.skill * 0.06;
	if ( aBot.bKamikaze )
		return 1;
	else if ( Other.IsA('TeamCannon') 
		|| (aBot.RelativeStrength(Other) > aBot.Aggressiveness + skillmod) )
		return 0;
	else
		return 1;
}

function float GameThreatAdd(Bot aBot, Pawn Other)
{
	return 0;
}

// AllowTranslocation - return true if Other can teleport to Dest
function bool AllowTranslocation(Pawn Other, vector Dest )
{
	return true;
}

function bool CanTranslocate(Bot aBot)
{
	if ( !bUseTranslocator || (bRatedGame && !bRatedTranslocator) )
		return false;
	return ( (aBot.MyTranslocator != None) && (aBot.MyTranslocator.TTarget == None) );
} 

function PickAmbushSpotFor(Bot aBot)
{
	local NavigationPoint N;

	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
		if ( N.IsA('Ambushpoint') && !N.taken 
			&& ((aBot.AmbushSpot == None)
				|| (VSize(aBot.Location - aBot.Ambushspot.Location)
					 > VSize(aBot.Location - N.Location))) )
				aBot.Ambushspot = Ambushpoint(N);
}

function RateVs(Pawn Other, Pawn Killer)
{
	local int numopp, Win;
	local float oppRating, K, We;
	Local PlayerPawn P;
	Local Bot B;

	if ( Killer.IsA('PlayerPawn') )
	{
		P = PlayerPawn(Killer);
		B = Bot(Other);
		Win = 1;
		WinCount++;
	}
	else if ( Other.IsA('PlayerPawn') )
	{
		LoseCount++;
		P = PlayerPawn(Other);
		B = Bot(Killer);
	}
	else
		return;

	if ( B == None )
		oppRating = PlayerRating - 400;
	else
		oppRating = FMin(B.GetRating(), PlayerRating + 400);

	numopp++;
	AvgOpponentRating = (AvgOpponentRating * (numopp - 1) + oppRating)/numopp;  	
	if ( numopp < 20 )
	{
		PlayerRating = AvgOpponentRating + 400 * (WinCount - LoseCount)/numopp;			
	}
	else
	{
		if ( oppRating < PlayerRating - 400 )
			return;
		
		if ( PlayerRating < 2100 )
			K = 32;
		else if ( PlayerRating < 2400 )
			K = 24;
		else 
			K = 16; 

		We = 1/(10^((PlayerRating - opprating)/400) + 1);
		PlayerRating = PlayerRating + K * (Win - We);

		/* FOLLOWING NOT DONE - do at end of level FIXME
		Pre-tournament Rating Post-tournament Rating   
		0-2099  2100-2399 Ra = 2100 + (Rn-2100) x 0.75  
		2100-2399 0-2099  Ra = 2100 + (Rn-2100) x 1.33  
		2100-2399 2400-3000 Ra = 2400 + (Rn-2400) x 0.66  
		2400-3000  2100-2399  Ra = 2400 + (Rn-2400) x 1.50 
		*/
	}
}

function bool SuccessfulGame()
{
	local Pawn P;

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if ( P.bIsPlayer && (P != RatedPlayer) )
			if ( P.PlayerReplicationInfo.Score >= RatedPlayer.PlayerReplicationInfo.Score )
				return false;

	return true;
}


// Commented out for release version.
function Skip()
{
	if (bRatedGame)
	{
		RatedGameLadderObj.LastMatchType = LadderTypeIndex;
		RatedGameLadderObj.PendingChange = LadderTypeIndex;
		if (IDnum < RatedGameLadderObj.CurrentLadder.Default.Matches-1)
			RatedGameLadderObj.PendingPosition = IDnum+1;
		RatedGameLadderObj.PendingRank = RatedGameLadderObj.CurrentLadder.Default.RankedGame[IDnum];

		RatedPlayer.ClientTravel("UT-Logo-Map.unr"$"?Game=Botpack.LadderTransition", TRAVEL_Absolute, True);
		return;
	}
}

function SkipAll()
{
	if (bRatedGame)
	{
		RatedGameLadderObj.DMPosition = class'LadderDMGOTY'.Default.Matches - 1;
		RatedGameLadderObj.DMRank = 6;
		RatedGameLadderObj.DOMPosition = class'LadderDOM'.Default.Matches - 1;
		RatedGameLadderObj.DOMRank = 6;
		RatedGameLadderObj.CTFPosition = class'LadderCTFGOTY'.Default.Matches - 1;
		RatedGameLadderObj.CTFRank = 6;
		RatedGameLadderObj.ASPosition = class'LadderAS'.Default.Matches - 1;
		RatedGameLadderObj.ASRank = 6;
		RatedGameLadderObj.ChalPosition = class'LadderChal'.Default.Matches - 1;
		RatedGameLadderObj.ChalRank = 6;

		RatedGameLadderObj.LastMatchType = LadderTypeIndex;
		RatedGameLadderObj.PendingChange = LadderTypeIndex;
		RatedGameLadderObj.PendingPosition = 0;
		RatedGameLadderObj.PendingRank = 0;

		RatedPlayer.ClientTravel("UT-Logo-Map.unr"$"?Game=Botpack.LadderTransition", TRAVEL_Absolute, True);
		return;
	}
}

function bool CanSpectate( pawn Viewer, actor ViewTarget )
{
	if ( ViewTarget.bIsPawn && (Pawn(ViewTarget).PlayerReplicationInfo != None)
		&& Pawn(ViewTarget).PlayerReplicationInfo.bIsSpectator )
		return false;
	return ( (!bRatedGame && (Level.NetMode == NM_Standalone)) || Viewer.PlayerReplicationInfo.bIsSpectator );
}

function bool ShouldRespawn(Actor Other)
{
	return ( (Inventory(Other) != None) && (Inventory(Other).ReSpawnTime!=0.0) );
}

function ChangeName(Pawn Other, string S, bool bNameChange)
{
	local pawn APlayer;

	if ( S == "" )
		return;

	S = left(S,24);
	if (Other.PlayerReplicationInfo.PlayerName~=S)
		return;
	
	APlayer = Level.PawnList;
	
	While ( APlayer != None )
	{	
		if ( APlayer.bIsPlayer && (APlayer.PlayerReplicationInfo.PlayerName~=S) )
		{
			Other.ClientMessage(S$NoNameChange);
			return;
		}
		APlayer = APlayer.NextPawn;
	}

	Other.PlayerReplicationInfo.OldName = Other.PlayerReplicationInfo.PlayerName;
	Other.PlayerReplicationInfo.PlayerName = S;
	if ( bNameChange && !Other.IsA('Spectator') )
		BroadcastLocalizedMessage( DMMessageClass, 2, Other.PlayerReplicationInfo );			

	if (LocalLog != None)
		LocalLog.LogNameChange(Other);
	if (WorldLog != None)
		WorldLog.LogNameChange(Other);
}

/* FindPlayerStart()
returns the 'best' player start for this player to start from.
Re-implement for each game type
*/
function NavigationPoint FindPlayerStart(Pawn Player, optional byte InTeam, optional string incomingName)
{
	local PlayerStart Dest, Candidate[16], Best;
	local float Score[16], BestScore, NextDist;
	local pawn OtherPlayer;
	local int i, num;
	local Teleporter Tel;
	local NavigationPoint N, LastPlayerStartSpot;

	if ( bStartMatch && (Player != None) && Player.IsA('TournamentPlayer') 
		&& (Level.NetMode == NM_Standalone)
		&& (TournamentPlayer(Player).StartSpot != None) )
		return TournamentPlayer(Player).StartSpot;

	if( incomingName!="" )
		foreach AllActors( class 'Teleporter', Tel )
			if( string(Tel.Tag)~=incomingName )
				return Tel;

	//choose candidates	
	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
	{
		Dest = PlayerStart(N);
		if ( (Dest != None) && Dest.bEnabled && !Dest.Region.Zone.bWaterZone )
		{
			if (num<16)
				Candidate[num] = Dest;
			else if (Rand(num) < 16)
				Candidate[Rand(16)] = Dest;
			num++;
		}
	}

	if (num == 0 )
		foreach AllActors( class 'PlayerStart', Dest )
		{
			if (num<16)
				Candidate[num] = Dest;
			else if (Rand(num) < 16)
				Candidate[Rand(16)] = Dest;
			num++;
		}

	if (num>16) num = 16;
	else if (num == 0)
		return None;

	if ( (Player != None) && Player.IsA('TournamentPlayer') 
		&& (TournamentPlayer(Player).StartSpot != None) )
		LastPlayerStartSpot = TournamentPlayer(Player).StartSpot;

	//assess candidates
	for (i=0;i<num;i++)
	{
		if ( (Candidate[i] == LastStartSpot) || (Candidate[i] == LastPlayerStartSpot) )
			Score[i] = -10000.0;
		else
			Score[i] = 3000 * FRand(); //randomize
	}		
	for ( OtherPlayer=Level.PawnList; OtherPlayer!=None; OtherPlayer=OtherPlayer.NextPawn)	
		if ( OtherPlayer.bIsPlayer && (OtherPlayer.Health > 0) && !OtherPlayer.IsA('Spectator') )
			for ( i=0; i<num; i++ )
			{
				if ( OtherPlayer.Region.Zone == Candidate[i].Region.Zone )
				{
					Score[i] -= 1500;
					NextDist = VSize(OtherPlayer.Location - Candidate[i].Location);
					if ( NextDist < OtherPlayer.CollisionRadius + OtherPlayer.CollisionHeight )
						Score[i] -= 1000000.0;
					else if ( (NextDist < 2000) && FastTrace(Candidate[i].Location, OtherPlayer.Location) )
						Score[i] -= (10000.0 - NextDist);
				}
				else if ( NumPlayers + NumBots == 2 )
				{
					Score[i] += 2 * VSize(OtherPlayer.Location - Candidate[i].Location);
					if ( FastTrace(Candidate[i].Location, OtherPlayer.Location) )
						Score[i] -= 10000;
				}
			}
	
	BestScore = Score[0];
	Best = Candidate[0];
	for (i=1;i<num;i++)
		if (Score[i] > BestScore)
		{
			BestScore = Score[i];
			Best = Candidate[i];
		}

	LastStartSpot = Best;
	return Best;
}

function Logout(pawn Exiting)
{
	Super.Logout(Exiting);
	if ( Exiting.IsA('Bot') )
		NumBots--;
	if ( Exiting.IsA('Commander') )
		NumCommanders--;
	if ( (Level.NetMode != NM_Standalone) && NeedPlayers() && !AddBot() )
		RemainingBots++;
}

function bool NeedPlayers()
{
	return (!bGameEnded && (NumPlayers + NumBots < MinPlayers));
}

function RestartGame()
{
	local string NextMap;
	local MapList myList;

	// multipurpose don't restart variable
	if ( bDontRestart )
		return;

	if ( EndTime > Level.TimeSeconds ) // still showing end screen
		return;

/*

	// Evaluate a rated game.
	if ( bRatedGame )
	{
		// Clear out the advancement fields.
		RatedGameLadderObj.PendingPosition = 0;
		RatedGameLadderObj.PendingRank = 0;
		RatedGameLadderObj.PendingChange = 0;

		// Setup advancement.
		RatedGameLadderObj.LastMatchType = LadderTypeIndex;
		if ( SuccessfulGame() )
		{
			RatedGameLadderObj.PendingChange = LadderTypeIndex;
			if (IDnum < RatedGameLadderObj.CurrentLadder.Default.Matches-1)
				RatedGameLadderObj.PendingPosition = IDnum+1;	// We are advancing to the next match.
			RatedGameLadderObj.PendingRank = RatedGameLadderObj.CurrentLadder.Default.RankedGame[IDnum];
		}

		RatedPlayer.Health = RatedPlayer.Default.Health;
		RatedPlayer.ClientTravel("UT-Logo-Map.unr"$"?Game=Botpack.LadderTransition", TRAVEL_Absolute, True);
		return;
	}


	// these server travels should all be relative to the current URL
	if ( bChangeLevels && !bAlreadyChanged && (MapListType != None) )
	{
		// open a the nextmap actor for this game type and get the next map
		bAlreadyChanged = true;
		myList = spawn(MapListType);
		NextMap = myList.GetNextMap();
		myList.Destroy();
		if ( NextMap == "" )
			NextMap = GetMapName(MapPrefix, NextMap,1);

		if ( NextMap != "" )
		{
			Level.ServerTravel(NextMap, false);
			return;
		}
	}

	Level.ServerTravel("?Restart" , false);
*/
}

function LogGameParameters(StatLog StatLog)
{
	local bool bTemp;

	if (StatLog == None)
		return;

	// hack to make sure weapon stay logging is correct for multiplayer games
	bTemp = bCoopWeaponMode;
	if ( Level.Netmode != NM_Standalone )
		bCoopWeaponMode = bMultiWeaponStay;	
	Super.LogGameParameters(StatLog);
	bCoopWeaponMode = bTemp;

	StatLog.LogEventString(StatLog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"FragLimit"$Chr(9)$FragLimit);
	StatLog.LogEventString(StatLog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"TimeLimit"$Chr(9)$TimeLimit);
	StatLog.LogEventString(StatLog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"MultiPlayerBots"$Chr(9)$(MinPlayers > 0));
	StatLog.LogEventString(StatLog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"HardCore"$Chr(9)$bHardCoreMode);
	StatLog.LogEventString(StatLog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"MegaSpeed"$Chr(9)$bMegaSpeed);
	StatLog.LogEventString(StatLog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"AirControl"$Chr(9)$AirControl);
	StatLog.LogEventString(StatLog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"JumpMatch"$Chr(9)$bJumpMatch);
	StatLog.LogEventString(StatLog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"UseTranslocator"$Chr(9)$bUseTranslocator);
	StatLog.LogEventString(StatLog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"TournamentMode"$Chr(9)$bTournament);
	if (Level.NetMode == NM_DedicatedServer)
		StatLog.LogEventString(StatLog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"NetMode"$Chr(9)$"DedicatedServer");
	else if (Level.NetMode == NM_ListenServer)
		StatLog.LogEventString(StatLog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"NetMode"$Chr(9)$"ListenServer");
	else if (Level.NetMode == NM_Standalone)
	{
		if (bRatedGame)
			StatLog.LogEventString(StatLog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"NetMode"$Chr(9)$"SinglePlayer");
		else
			StatLog.LogEventString(StatLog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"NetMode"$Chr(9)$"PracticeMatch");
	}
}

//------------------------------------------------------------------------------
// Game Querying.

function string GetRules()
{
	local string ResultSet;
	ResultSet = Super.GetRules();

	ResultSet = ResultSet$"\\timelimit\\"$TimeLimit;
	ResultSet = ResultSet$"\\fraglimit\\"$FragLimit;
	Resultset = ResultSet$"\\minplayers\\"$MinPlayers;
	Resultset = ResultSet$"\\changelevels\\"$bChangeLevels;
	Resultset = ResultSet$"\\tournament\\"$bTournament;
	if(bMegaSpeed)
		Resultset = ResultSet$"\\gamestyle\\Turbo";
	else
	if(bHardcoreMode)
		Resultset = ResultSet$"\\gamestyle\\Hardcore";
	else
		Resultset = ResultSet$"\\gamestyle\\Classic";

	if(MinPlayers > 0)
		Resultset = ResultSet$"\\botskill\\"$class'ChallengeBotInfo'.default.Skills[Difficulty];

	return ResultSet;
}

function InitGameReplicationInfo()
{
	Super.InitGameReplicationInfo();

	US_GRI(TournamentGameReplicationInfo(GameReplicationInfo)).FragLimit = FragLimit;
	US_GRI(TournamentGameReplicationInfo(GameReplicationInfo)).TimeLimit = TimeLimit;
}

function bool CheckThisTranslocator(Bot aBot, TranslocatorTarget T)
{
	return false;
}

function bool OneOnOne()
{
	return ( NumPlayers + NumBots == 2 );
}

function float SpawnWait(bot B)
{
	if ( bRatedGame && bNoviceMode && !bTeamGame && (Difficulty <= 2) 
		&& (NumBots > 1)
		&& (B.PlayerReplicationInfo.Score > RatedPlayer.PlayerReplicationInfo.Score) )
		return ( 7 + NumBots * FRand() );
	return ( NumBots * FRand() );
}
	
function bool NeverStakeOut(bot Other)
{
	return false;
}

defaultproperties
{
     AirControl=0.350000
     FragLimit=30
     bChangeLevels=True
     bHardCoreMode=True
     bMultiWeaponStay=True
     NetWait=10
     RestartWait=15
     CountDown=10
     TourneyMessage="Waiting for other players."
     WaitingMessage1="Waiting for ready signals."
     WaitingMessage2="(Use your fire button to toggle ready!)"
     ReadyMessage="You are READY!"
     NotReadyMessage="You are NOT READY!"
     CountDownMessage=" seconds until play starts!"
     StartMessage="The match has begun!"
     GameEndedMessage="wins the match!"
     SingleWaitingMessage="Press Fire to start."
     gamegoal="frags wins the match."
     InitialBots=4
     NoNameChange=" is already in use."
     OvertimeMessage="Score tied at the end of regulation. Sudden Death Overtime!!!"
     BotConfigType=Class'Botpack.ChallengeBotInfo'
     LadderTypeIndex=1
     bNoMonsters=True
     bRestartLevel=False
     bPauseable=False
     bDeathMatch=True
     ScoreBoardType=Class'US_SB'
     BotMenuType="UTMenu.UTBotConfigSClient"
     RulesMenuType="UTMenu.UTRulesSClient"
     SettingsMenuType="UTMenu.UTSettingsSClient"
     GameUMenuType="UTMenu.UTGameMenu"
     MultiplayerUMenuType="UTMenu.UTMultiplayerMenu"
     GameOptionsMenuType="UTMenu.UTOptionsMenu"
     HUDType=Class'US_HUD'
     MapListType=Class'Botpack.TDMmaplist'
     MapPrefix="DM"
     BeaconName="DM"
     GameName="Universal Soldiers"
     DeathMessageClass=Class'US_DeathMessage'
     DMMessageClass=Class'Botpack.DeathMatchMessage'
     MutatorClass=Class'US_BaseMutator'
     GameReplicationInfoClass=Class'US_GRI'
     bLoggingGame=True
}